/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.util;

import com.ibm.hwmca.base.time.TimeManager;
import com.ibm.hwmca.base.time.event.TimeChangedOnConsoleEvent;
import com.ibm.hwmca.base.time.event.TimeChangedOnConsoleListener;
import com.ibm.hwmca.fw.util.HMCTimerTask;
import com.ibm.hwmca.fw.util.TimerParms;
import com.ibm.hwmca.fw.util.TimerTaskControl;
import com.ibm.hwmca.fw.util.TimerTaskExecutionControl;
import com.ibm.hwmca.fw.util.Trace;
import java.security.SecureRandom;
import java.util.Date;

public final class HMCTimer {
    private static final boolean debug = false;
    private static final String TRACE_MASKT = "XH-TIMET";
    private static final String TRACE_MASKF = "XH-TIMEF";
    private static final String TRACE_MASKD = "XH-TIMED";
    private static HMCTimer theSingleTimer = null;
    private static final int TIMER_THREAD_LIMIT = 25;
    private String name = null;
    private boolean terminate = false;
    private HMCTaskQueue queue = new HMCTaskQueue();
    private HMCTimerThread timerThread = null;
    private int threadCnt = 0;
    private int currentActiveTimerThreads = 0;

    public static void main(String[] args) {
        new HMCTaskQueue().driveTestCase();
    }

    public static synchronized HMCTimer getHMCTimer() {
        if (theSingleTimer == null) {
            theSingleTimer = new HMCTimer("Common HMC-Timer");
        }
        return theSingleTimer;
    }

    private HMCTimer(String name) {
        this.name = name;
        this.timerThread = new HMCTimerThread(name + "-service:" + this.threadCnt++);
        this.timerThread.setDaemon(true);
        ++this.currentActiveTimerThreads;
        this.timerThread.start();
        HMCTimerGuardThread watcherThread = new HMCTimerGuardThread(name + "-guard");
        watcherThread.setDaemon(true);
        watcherThread.start();
        TimeManager.getTimeManager().addTimeChangedOnConsoleListener(this.queue);
    }

    protected void finalize() {
        this.terminate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TimerTaskControl scheduleTask(TimerParms parms) {
        ProxiedTimerTask pTask = new ProxiedTimerTask(this.queue, this.name, parms);
        HMCTaskQueue hMCTaskQueue = this.queue;
        synchronized (hMCTaskQueue) {
            this.queue.add(pTask);
            this.queue.notifyAll();
        }
        return pTask;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void terminate() {
        Trace.trace(TRACE_MASKF, "Timer: " + this.name + ", terminate()");
        HMCTaskQueue hMCTaskQueue = this.queue;
        synchronized (hMCTaskQueue) {
            this.terminate = true;
            this.queue.notifyAll();
        }
    }

    public TimerTaskControl schedule(HMCTimerTask task, long delay) {
        Trace.trace(TRACE_MASKF, "Timer: " + this.name + ", schedule(" + task + ", " + delay + ")");
        TimerParms tp = new TimerParms(delay);
        tp.setTask(task);
        return this.scheduleTask(tp);
    }

    public TimerTaskControl schedule(HMCTimerTask task, Date time) {
        Trace.trace(TRACE_MASKF, "Timer: " + this.name + ", schedule(" + task + ", " + time + ")");
        TimerParms tp = new TimerParms(time);
        tp.setTask(task);
        return this.scheduleTask(tp);
    }

    public TimerTaskControl schedule(HMCTimerTask task, TimerParms parms) {
        Trace.trace(TRACE_MASKF, "Timer: " + this.name + ", schedule(" + task + ", " + parms + ")");
        parms.setTask(task);
        return this.scheduleTask(parms);
    }

    class HMCTimerThread
    extends Thread {
        boolean timerThread = true;
        ProxiedTimerTask runningTask = null;

        HMCTimerThread(String name) {
            super(name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setTimerThread(boolean value) {
            HMCTaskQueue hMCTaskQueue = HMCTimer.this.queue;
            synchronized (hMCTaskQueue) {
                this.timerThread = value;
                HMCTimer.this.queue.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            Trace.trace(HMCTimer.TRACE_MASKF, "HMC-Timer thread ('" + Thread.currentThread().getName() + "') begins running.");
            try {
                while (!HMCTimer.this.terminate && this.timerThread) {
                    HMCTaskQueue hMCTaskQueue;
                    Object var7_5;
                    ProxiedTimerTask pTask = null;
                    try {
                        HMCTaskQueue hMCTaskQueue2 = HMCTimer.this.queue;
                        synchronized (hMCTaskQueue2) {
                            while (HMCTimer.this.queue.isEmpty() && !HMCTimer.this.terminate && this.timerThread) {
                                HMCTimer.this.queue.wait();
                            }
                            if (!HMCTimer.this.terminate && this.timerThread) {
                                pTask = HMCTimer.this.queue.next();
                                if (pTask.canceled) {
                                    HMCTimer.this.queue.remove();
                                } else {
                                    long currentTime = System.currentTimeMillis();
                                    if (pTask.nextExecutionTime <= currentTime) {
                                        pTask.scheduledExecutionTime = pTask.nextExecutionTime;
                                        if (pTask.period == 0L) {
                                            HMCTimer.this.queue.remove();
                                        } else {
                                            HMCTimer.this.queue.reschedule(pTask.reschedule(currentTime));
                                        }
                                        if (!pTask.active) {
                                            this.runningTask = pTask;
                                            pTask.active = true;
                                            HMCTimer.this.queue.notifyAll();
                                        }
                                    } else {
                                        HMCTimer.this.queue.wait(pTask.nextExecutionTime - currentTime);
                                    }
                                }
                            }
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (this.runningTask == null) continue;
                    try {
                        this.runningTask.run();
                        var7_5 = null;
                    }
                    catch (Throwable throwable) {
                        var7_5 = null;
                        hMCTaskQueue = HMCTimer.this.queue;
                        synchronized (hMCTaskQueue) {
                            this.runningTask.active = false;
                            this.runningTask = null;
                            HMCTimer.this.queue.notifyAll();
                            throw throwable;
                        }
                    }
                    hMCTaskQueue = HMCTimer.this.queue;
                    synchronized (hMCTaskQueue) {
                        this.runningTask.active = false;
                        this.runningTask = null;
                        HMCTimer.this.queue.notifyAll();
                    }
                }
                Object var11_8 = null;
            }
            catch (Throwable throwable) {
                Object var11_9 = null;
                HMCTaskQueue hMCTaskQueue = HMCTimer.this.queue;
                synchronized (hMCTaskQueue) {
                    HMCTimer.this.currentActiveTimerThreads--;
                    HMCTimer.this.queue.notifyAll();
                }
                Trace.trace(HMCTimer.TRACE_MASKF, "HMC-Timer thread ('" + Thread.currentThread().getName() + "') ends.");
                throw throwable;
            }
            HMCTaskQueue hMCTaskQueue = HMCTimer.this.queue;
            synchronized (hMCTaskQueue) {
                HMCTimer.this.currentActiveTimerThreads--;
                HMCTimer.this.queue.notifyAll();
            }
            Trace.trace(HMCTimer.TRACE_MASKF, "HMC-Timer thread ('" + Thread.currentThread().getName() + "') ends.");
        }
    }

    class HMCTimerGuardThread
    extends Thread {
        HMCTimerGuardThread(String name) {
            super(name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Trace.trace(HMCTimer.TRACE_MASKF, "HMC-Timer thread ('" + Thread.currentThread().getName() + "') begins running.");
            while (!HMCTimer.this.terminate) {
                HMCTaskQueue hMCTaskQueue = HMCTimer.this.queue;
                synchronized (hMCTaskQueue) {
                    while ((HMCTimer.this.currentActiveTimerThreads >= 25 || HMCTimer.this.queue.isEmpty() || ((HMCTimer)HMCTimer.this).timerThread.runningTask == null) && !HMCTimer.this.terminate) {
                        if (HMCTimer.this.currentActiveTimerThreads >= 25) {
                            Trace.trace(HMCTimer.TRACE_MASKF, "Warning: HMC-Timer ('" + Thread.currentThread().getName() + "') is at the maximum allowable thread count (" + 25 + ").");
                        }
                        try {
                            HMCTimer.this.queue.wait();
                        }
                        catch (InterruptedException e) {}
                    }
                    if (!HMCTimer.this.terminate) {
                        ProxiedTimerTask pTask = HMCTimer.this.queue.next();
                        long currentTime = System.currentTimeMillis();
                        if (pTask.nextExecutionTime <= currentTime) {
                            if (pTask.active) {
                                HMCTimer.this.queue.reschedule(pTask.reschedule(currentTime));
                                continue;
                            }
                            HMCTimer.this.timerThread.setTimerThread(false);
                            HMCTimer.this.timerThread = new HMCTimerThread(HMCTimer.this.name + "-service:" + HMCTimer.this.threadCnt++);
                            HMCTimer.this.timerThread.setDaemon(true);
                            HMCTimer.this.currentActiveTimerThreads++;
                            HMCTimer.this.timerThread.start();
                        } else {
                            try {
                                HMCTimer.this.queue.wait(pTask.nextExecutionTime - currentTime);
                            }
                            catch (InterruptedException e) {
                                // empty catch block
                            }
                        }
                    }
                }
            }
            Trace.trace(HMCTimer.TRACE_MASKF, "HMC-Timer thread ('" + Thread.currentThread().getName() + "') ends.");
        }
    }

    static class HMCTaskQueue
    implements TimeChangedOnConsoleListener {
        ProxiedTimerTask[] internalQueue = new ProxiedTimerTask[128];
        int size = 0;

        HMCTaskQueue() {
        }

        void add(ProxiedTimerTask task) {
            if (++this.size == this.internalQueue.length) {
                ProxiedTimerTask[] newQueue = new ProxiedTimerTask[2 * this.internalQueue.length];
                System.arraycopy(this.internalQueue, 0, newQueue, 0, this.internalQueue.length);
                this.internalQueue = newQueue;
            }
            for (int hole = this.size; hole > 1 && task.nextExecutionTime - this.internalQueue[hole / 2].nextExecutionTime < 0L; hole /= 2) {
                this.internalQueue[hole] = this.internalQueue[hole / 2];
            }
            this.internalQueue[hole] = task;
        }

        ProxiedTimerTask next() {
            return this.internalQueue[1];
        }

        void remove() {
            if (this.size > 0) {
                this.internalQueue[1] = this.internalQueue[this.size];
                this.internalQueue[this.size--] = null;
                this.moveDown(1);
            }
        }

        void reschedule(long newTime) {
            this.internalQueue[1].nextExecutionTime = newTime;
            this.moveDown(1);
        }

        boolean isEmpty() {
            return this.size == 0;
        }

        void clear() {
            for (int i = 1; i <= this.size; ++i) {
                this.internalQueue[i] = null;
            }
            this.size = 0;
        }

        public synchronized void timeChangedOnConsole(TimeChangedOnConsoleEvent event) {
            ProxiedTimerTask[] oldQueue = this.internalQueue;
            this.internalQueue = new ProxiedTimerTask[this.internalQueue.length];
            this.size = 0;
            for (int i = 1; i <= this.size; ++i) {
                oldQueue[i].timeChanged(event);
                this.add(oldQueue[i]);
            }
        }

        private void moveDown(int hole) {
            ProxiedTimerTask tmp = this.internalQueue[hole];
            while (hole * 2 <= this.size) {
                int child = hole * 2;
                if (child != this.size && this.internalQueue[child + 1].nextExecutionTime - this.internalQueue[child].nextExecutionTime < 0L) {
                    ++child;
                }
                if (this.internalQueue[child].nextExecutionTime - tmp.nextExecutionTime >= 0L) break;
                this.internalQueue[hole] = this.internalQueue[child];
                hole = child;
            }
            this.internalQueue[hole] = tmp;
        }

        private void assertStatus() {
            for (int i = 2; i <= this.size; ++i) {
                if (this.internalQueue[1].nextExecutionTime <= this.internalQueue[i].nextExecutionTime) continue;
                this.assertFails("ASSERT FAILS!  " + this.internalQueue[1].nextExecutionTime + " is not less than " + this.internalQueue[i].nextExecutionTime + " (index=" + i + ")");
            }
        }

        private void debugMessages(String msg) {
            System.out.println(msg);
        }

        private void assertFails(String msg) {
            System.out.println(msg);
            System.out.println("\tinternalQueue.length=" + this.internalQueue.length + "\tsize=" + this.size);
            for (int ji = 0; ji <= this.size; ++ji) {
                System.out.println("\t" + (this.internalQueue[ji] == null ? "null" : Long.toString(this.internalQueue[ji].nextExecutionTime)));
            }
            System.exit(-1);
        }

        void driveTestCase() {
            SecureRandom rand = new SecureRandom();
            for (int i = 0; i < 1000000; ++i) {
                for (int j = 0; j < 10000; ++j) {
                    long aRand = Math.abs(rand.nextLong() % 100000L);
                    this.add(new ProxiedTimerTask(aRand));
                    if (aRand > 80000L) {
                        this.remove();
                    }
                    if (this.size <= 5000) continue;
                    int toRemove = Math.abs(rand.nextInt() % 4000);
                    for (int k = 0; k < toRemove; ++k) {
                        this.remove();
                    }
                }
                System.out.println("Pass " + i + " (" + (10000 + i * 10000) + " adds)");
            }
        }
    }

    static class ProxiedTimerTask
    implements TimerTaskExecutionControl {
        HMCTimerTask task;
        boolean active;
        long nextExecutionTime;
        long scheduledExecutionTime;
        long period = 0L;
        boolean canceled = false;
        boolean fixedDelay = true;
        Object runParm = null;
        Object notifyLock = null;
        String name = "";

        ProxiedTimerTask(Object notifyLock, String name, TimerParms parms) {
            this.notifyLock = notifyLock;
            this.name = name;
            this.task = parms.task;
            this.period = parms.period;
            this.fixedDelay = parms.fixedDelay;
            this.nextExecutionTime = parms.start;
            this.runParm = parms.runParm;
        }

        ProxiedTimerTask(long nextExecutionTime) {
            this.nextExecutionTime = nextExecutionTime;
        }

        public long scheduledExecutionTime() {
            return this.scheduledExecutionTime;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cancel() {
            this.canceled = true;
            Object object = this.notifyLock;
            synchronized (object) {
                this.notifyLock.notifyAll();
            }
        }

        void run() {
            try {
                this.task.run(this, this.runParm);
            }
            catch (Throwable e) {
                if (e instanceof ThreadDeath) {
                    throw (ThreadDeath)e;
                }
                Trace.trace(HMCTimer.TRACE_MASKF, "Throwable (" + e + ") from task (" + this.task + ") consumed by " + this.name + ".");
                Trace.trace(HMCTimer.TRACE_MASKF, e);
            }
        }

        public String toString() {
            return "TimerProxy[" + this.nextExecutionTime + "," + this.period + "," + this.fixedDelay + "," + this.task + "]";
        }

        long reschedule(long currentTime) {
            if (this.fixedDelay) {
                return currentTime + this.period;
            }
            return this.nextExecutionTime + this.period;
        }

        void timeChanged(TimeChangedOnConsoleEvent event) {
        }
    }
}

